FLAG = int.from_bytes("REDACTED".encode(), "big")

from mpmath import mp
import mpmath
import random
mp.dps = 500
rng = random.SystemRandom()
mpmath.libmp.libmpf.getrandbits = rng.getrandbits
coeffs = [rng.randrange(0, 2**128) for _ in range(5)]
def ev(x):
    r = 0
    for c in coeffs[::-1]:
        r = (x * r) + c
    return r
def rnd_x():
    return mp.rand() * 10
print([(str(x := rnd_x()), str(ev(x))) for _ in range(3)])
print(FLAG ^ coeffs[0])
